package org.msh.tb.bd.dashboard.query;

import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.TbFormField;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 24/05/2017.
 */
public class Indicator11Query extends IndicatorQuery {

    /**
     * @return The result used by IndicatorParser to create the dashboard summarized report.
     */
    public List<Object[]> getSummaryResult(){
        List<Object[]> ret;

        if (getSelectedAdminUnit() != null) {
            // create administrative unit condition
            String auCondition = "and u.adminUnit.code like '" + getSelectedAdminUnit().getCode() + "%' ";
            ret = includeRate(getQueryResult(auCondition));
        } else {
            // this will return the result for first level of admin unit
            List<Object[]> results = getDetailedResult();

            ret = new ArrayList<Object[]>();
            // get root result
            ret.add(results.get(results.size()-1));
        }

        return ret;
    }

    @Override
    public List<Object[]> getDetailedResult(){
        // create administrative unit condition
        String auCondition = "";

        if (getSelectedAdminUnit() != null) {
            auCondition = "and u.adminUnit.code like '" + getSelectedAdminUnit().getCode() + "%' ";
        }

        //get database result and include for each result its rate
        List<Object[]> ret = includeRate(getQueryResult(auCondition));

        // calculate root
        long rootNum1 = 0;
        long rootNum2 = 0;

        for (Object[] o : ret){
            if (o[1] != null) {
                rootNum1 = rootNum1 + (Long) o[1];
            }

            if (o[2] != null) {
                rootNum2 = rootNum2 + (Long) o[2];
            }
        }

        Object[] root = new Object[] {"root",
                rootNum1,
                rootNum2,
                calculateRate(new Object[]{null, rootNum1, rootNum2}),
                calcPerformanceRating(rootNum2, rootNum1)};

        ret.add(root);

        return ret;
    }

    @Override
    public Float calculateRate(Object[] o) {
        Long num1 = (Long) o[1];
        Long num2 = (Long) o[2];

        Float rate = DashboardIndicatorUtils.calcPercentage(num1, num2);

        return rate > 100.00 ? new Float(100.00) : rate;
    }

    @Override
    protected List<Object[]> includeRate(List<Object[]> result) {
        List<Object[]> newResult = new ArrayList<Object[]>();

        for (Object[] o : result) {
            Object[] newObj = new Object[]{o[0], o[1], o[2], calculateRate(o), calcPerformanceRating((Long)o[2], (Long)o[1])};
            newResult.add(newObj);
        }

        return newResult;
    }

    @Override
    protected List<Object[]> getQueryResult(String adminUnitCondition) {
        // query indicator result
        // get population by administrative units child of auSelected
        // get new and relapses cases notified inside each of these administrative units
        List<Object[]> result = getEntityManager().createQuery("select u.name.name1, " +
                "(select count(*) " +
                    "from TbCaseBD c join c.patient p " +
                    "where c.registrationDate between :iniDate and :endDate " +
                    "and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) ) " +
                    "and c.classification = 0 and c.diagnosisType = 1 and c.age is not null and p.gender is not null " +
                    "and c.caseDefinition is not null and c.infectionSite is not null " +
                    "and c.notificationUnit.id = u.id) as caseqtt, " +
                "(select sum(v.value) " +
                    "from TbFormValue v " +
                    "where v.tbunit.id = u.id and v.referenceDate = :iniDate " +
                    "and v.field = :field) as manualpres " +
                "from Tbunit u " +
                "where u.workspace.id = :wsId " + adminUnitCondition +
                " and (select sum(v.value) " +
                        "from TbFormValue v " +
                        "where v.tbunit.id = u.id and v.referenceDate = :iniDate " +
                        "and v.field = :field) > 0 " + // manual presentation can't be null or zero
                "order by u.name.name1 ")
                .setParameter("iniDate", getIniDate())
                .setParameter("endDate", getEndDate())
                .setParameter("field", TbFormField.TB10_TOTAL_CASES_PRESENTED_MANUALLY)
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        return result;
    }

    private Float calcPerformanceRating(Long num1, Long num2) {
        if (num1 == null || num1 <= 0 || num2 == null || num2 <= 0) {
            return new Float(-1);
        }

        int difference = num1.intValue() - num2.intValue();

        if (difference <= 5) {
            return new Float(1);
        } else if (difference > 5 && difference <= 24) {
            return new Float(2);
        } else if (difference > 24 && difference <= 49) {
            return new Float(3);
        } else {
            return new Float(4);
        }
    }
}
